#!/bin/bash
echo "Установка GNS3 в среде ALSE 1.8"
echo "==============================="
echo -n "Нажмите ВВОД (Enter) для начала установки..."
read

sudo apt update
sudo apt -y install debian-archive-keyring
sudo touch /etc/apt/sources.list.d/gns3.list
echo "deb [arch=amd64] https://deb.debian.org/debian/ bookworm main contrib non-free non-free-firmware" | sudo tee -a /etc/apt/sources.list.d/gns3.list
sudo apt update

sudo apt -y install python3 python3-pip pipx python3-pyqt5 python3-pyqt5.qtwebsockets python3-pyqt5.qtsvg qemu-kvm qemu-utils libvirt-clients libvirt-daemon-system virtinst dynamips software-properties-common ca-certificates curl gnupg2

pipx install gns3-server
pipx install gns3-gui

pipx inject gns3-gui gns3-server PyQt5

sudo rm /etc/apt/sources.list.d/gns3.list
sudo apt update

mkdir $HOME/.gns3/
cp src/* $HOME/.gns3/
cp src/gns3server.desktop $HOME/Desktops/Desktop1/
cp src/gns3client.desktop $HOME/Desktops/Desktop1/

echo "===Операции завершены!==="
echo "=>Запуск сервера: $HOME/.local/bin/gns3server"
echo "=>Запуск клиента: $HOME/.local/bin/gns3"
echo "=>Созданы ярлыки на Рабочем Столе"
exit 0
